/* 
Copyright (c) 2015, Vincent Garreau

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/ 

(function(wpvclwdp_particle) {
    var wpvclwdp_lightweight_dust_effect_function = function(element_this, element_id) {
        
        var selector = wpvclwdp_particle(element_this);
        
        particlesJS( element_id, {
          "particles": {
            "number": {
              "value": selector.data('number'),
              "density": {
                "enable": true,
                "value_area": 800
              }
            },
            "color": {
              "value": selector.data('color')
            },
            "shape": {
              "type": "circle",
              "stroke": {
                "width": 0,
                "color": "#000000"
              }
            },
            "opacity": {
              "value": selector.data('opacityvalue'),
              "random": selector.data('opacityrandom'),
              "anim": {
                "enable": true,
                "speed": 1,
                "opacity_min": 0.1,
                "sync": false
              }
            },
            "size": {
              "value": selector.data('sizevalue'),
              "random": selector.data('sizerandom'),
              "anim": {
                "enable": true,
                "speed": 2,
                "size_min": 0.1,
                "sync": false
              }
            },
            "line_linked": {
              "enable": false
            },
            "move": {
              "enable": true,
              "speed": selector.data('movespeed'),
              "direction": selector.data('movedirection'),
              "random": false,
              "straight": false,
              "out_mode": "out",
              "bounce": false,
              "attract": {
                "enable": false,
                "rotatex": 600,
                "rotatey": 1200
              }
            }
          },
          "interactivity": {
            "detect_on": selector.data('interactiondetecton'),
            "events": {
              "onhover": {
                "enable": selector.data('interactionenableonhover'),
                "mode": selector.data('interactiononhovermode')
              },
              "onclick": {
                "enable": selector.data('interactionenableonclick'),
                "mode": selector.data('interactiononclickmode')
              },
              "resize": true
            },
            "modes": {
              "grab": {
                "distance": 400,
                "line_linked": {
                  "opacity": 1
                }
              },
              "bubble": {
                "distance": selector.data('modebubbledistance'),
                "size": selector.data('modebubblesize'),
                "duration": selector.data('modebubbleduration'),
                "opacity": selector.data('modebubbleopacity')
              },
              "repulse": {
                "distance": selector.data('moderepulsedistance'),
                "duration": selector.data('moderepulseduration')
              },
              "push": {
                "particles_nb": 4
              },
              "remove": {
                "particles_nb": 2
              }
            }
          },
          "retina_detect": true
        });
    }
    
    wpvclwdp_particle(document).ready(function() {
        // Check canvas support
        var canvasSupport = !!document.createElement('canvas').getContext;
        if (!canvasSupport) { return; }
        
        wpvclwdp_particle(document).find("div#wpvclwdp_vc_row").each(function() {
            var selector = wpvclwdp_particle(this);
            var prev = selector.prev();
            if (prev.hasClass("vc_row-full-width") && prev.prev().hasClass("vc_row")) {
                prev.prev().prepend(selector);
            } else {
                prev.prepend(selector);
            }
            wpvclwdp_lightweight_dust_effect_function( this, 'wpvclwdp_vc_row' );
		} );
        
        wpvclwdp_particle(document).find("div#wpvclwdp_vc_column").each(function() {
            var selector = wpvclwdp_particle(this);
            var prev = selector.prev();
            prev.prepend(selector);
            wpvclwdp_lightweight_dust_effect_function( this, 'wpvclwdp_vc_column' );
		} );
    });    
})(jQuery);