/* 
Copyright (c) 2015, Vincent Garreau

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/ 

(function(wpvclwstp_particle) {
    var wpvclwstp_lightweight_star_effect_function = function(element_this, element_id) {
        
        var selector = wpvclwstp_particle(element_this);
        
        particlesJS( element_id, {
          "particles": {
            "number": {
              "value": selector.data('number'),
              "density": {
                "enable": false,
                "value_area": 800
              }
            },
            "color": {
              "value": selector.data('color')
            },
            "shape": {
              "type": "star",
              "stroke": {
                "width": 0,
                "color": "#000000"
              },
              "polygon": {
                "nb_sides": 5
              }
            },
            "opacity": {
              "value": selector.data('opacityvalue'),
              "random": selector.data('opacityrandom'),
              "anim": {
                "enable": false,
                "speed": 1,
                "opacity_min": 0.1,
                "sync": false
              }
            },
            "size": {
              "value": selector.data('sizevalue'),
              "random": selector.data('sizerandom'),
              "anim": {
                "enable": false,
                "speed": 40,
                "size_min": 0.1,
                "sync": false
              }
            },
            "line_linked": {
              "enable": false,
              "distance": 150,
              "color": "#ffffff",
              "opacity": 0.4,
              "width": 1
            },
            "move": {
              "enable": true,
              "speed": selector.data('movespeed'),
              "direction": selector.data('movedirection'),
              "random": false,
              "straight": true,
              "out_mode": "out",
              "bounce": false,
              "attract": {
                "enable": false,
                "rotateX": 600,
                "rotateY": 1200
              }
            }
          },
          "interactivity": {
            "detect_on": selector.data('interactiondetecton'),
            "events": {
              "onhover": {
                "enable": selector.data('interactionenableonhover'),
                "mode": selector.data('interactiononhovermode')
              },
              "onclick": {
                "enable": selector.data('interactionenableonclick'),
                "mode": selector.data('interactiononclickmode')
              },
              "resize": true
            },
            "modes": {
              "grab": {
                "distance": 200,
                "line_linked": {
                  "opacity": 1
                }
              },
              "bubble": {
                "distance": selector.data('modebubbledistance'),
                "size": selector.data('modebubblesize'),
                "duration": selector.data('modebubbleduration'),
                "opacity": selector.data('modebubbleopacity')
              },
              "repulse": {
                "distance": selector.data('moderepulsedistance'),
                "duration": selector.data('moderepulseduration')
              },
              "push": {
                "particles_nb": 4
              },
              "remove": {
                "particles_nb": 2
              }
            }
          },
          "retina_detect": true
        });
    }
    
    wpvclwstp_particle(document).ready(function() {
        // Check canvas support
        var canvasSupport = !!document.createElement('canvas').getContext;
        if (!canvasSupport) { return; }
        
        wpvclwstp_particle(document).find("div#wpvclwstp_vc_row").each(function() {
            var selector = wpvclwstp_particle(this);
            var prev = selector.prev();
            
            if (prev.hasClass("vc_row-full-width") && prev.prev().hasClass("vc_row")) {
                prev.prev().prepend(selector);
            } else {
                prev.prepend(selector);
            }
            selector.addClass('vcrbp_particles');
            wpvclwstp_lightweight_star_effect_function( this, 'wpvclwstp_vc_row' );
		} );
        
        wpvclwstp_particle(document).find("div#wpvclwstp_vc_column").each(function() {
            var selector = wpvclwstp_particle(this);
            var prev = selector.prev();
            prev.prepend(selector);
            selector.addClass('vcrbp_particles');
            wpvclwstp_lightweight_star_effect_function( this, 'wpvclwstp_vc_column' );
		} );
    });    
    
    wpvclwstp_particle("span.vc_general.vc_ui-button.vc_ui-button-shape-rounded.vc_ui-button-fw.vc_ui-button-action", window.parent.document).bind("click", function() {
        wpvclwstp_admin_particle();
    });
    
    wpvclwstp_particle("span.vc_general.vc_ui-button.vc_ui-button-action.vc_ui-button-shape-rounded.vc_ui-button-fw", window.parent.document).bind("click", function() {
        wpvclwstp_admin_particle();
    });
    
    var wpvclwstp_admin_particle = function() {    
        wpvclwstp_particle(document).find(".vcrbp_particles").remove();

        setTimeout( function () {
            wpvclwstp_particle(document).find("div#wpvclwstp_vc_row").each(function() {
                var selector = wpvclwstp_particle(this);
                var prev = selector.prev();
                
                if (prev.hasClass("vc_row-full-width") && prev.prev().hasClass("vc_row")) {
                    prev.prev().prepend(selector);
                } else {
                    prev.prepend(selector);
                }
                selector.addClass('vcrbp_particles');
                wpvclwstp_lightweight_star_effect_function( this, 'wpvclwstp_vc_row' );
            } );
            
            wpvclwstp_particle(document).find("div#wpvclwstp_vc_column").each(function() {
                var selector = wpvclwstp_particle(this);
                var prev = selector.prev();
                prev.prepend(selector);
                selector.addClass('vcrbp_particles');
                wpvclwstp_lightweight_star_effect_function( this, 'wpvclwstp_vc_column' );
            } );
        }, 2000 );
    };  
})(jQuery);