<?php

$directory = "/home/masrcom1/public_html/test";

function listLargestDirectories($dir, &$results = []) {
    $totalSize = 0;
    $files = scandir($dir);

    foreach ($files as $file) {
        if ($file == "." || $file == "..") continue;
        $path = realpath($dir . DIRECTORY_SEPARATOR . $file);
        if (is_dir($path)) {
            $totalSize += listLargestDirectories($path, $results);
        } else {
            $totalSize += filesize($path);
        }
    }

    $results[$dir] = $totalSize;
    return $totalSize;
}

$results = [];
listLargestDirectories($directory, $results);

// Ordenar directorios por tamaño, de mayor a menor
arsort($results);

// Mostrar las 10 carpetas más grandes
$topDirectories = array_slice($results, 0, 10, true);

echo "<table border='1'>";
echo "<tr><th>Carpeta</th><th>Tamaño</th></tr>";
foreach ($topDirectories as $dir => $size) {
    echo "<tr><td>" . htmlspecialchars($dir) . "</td><td>" . formatSize($size) . "</td></tr>";
}
echo "</table>";

function formatSize($bytes, $precision = 2) {
    $units = array('B', 'KB', 'MB', 'GB', 'TB');

    $bytes = max($bytes, 0);
    $pow = floor(($bytes ? log($bytes) : 0) / log(1024));
    $pow = min($pow, count($units) - 1);

    $bytes /= pow(1024, $pow);

    return round($bytes, $precision) . ' ' . $units[$pow];
}