<?php

$directory = "/home/masrcom1/public_html";

function listLargestFiles($dir, &$results = []) {
    $files = scandir($dir);

    foreach ($files as $key => $value) {
        $path = realpath($dir . DIRECTORY_SEPARATOR . $value);
        if (!is_dir($path)) {
            $results[$path] = filesize($path);
        } else if ($value != "." && $value != "..") {
            listLargestFiles($path, $results);
        }
    }
}

$results = [];
listLargestFiles($directory, $results);

// Ordenar archivos por tamaño, de mayor a menor
arsort($results);

// Mostrar los 20 archivos más grandes
$topFiles = array_slice($results, 0, 20);

echo "<table border='1'>";
echo "<tr><th>Archivo</th><th>Tamaño</th></tr>";
foreach ($topFiles as $file => $size) {
    echo "<tr><td>" . htmlspecialchars($file) . "</td><td>" . formatSize($size) . "</td></tr>";
}
echo "</table>";

function formatSize($bytes, $precision = 2) {
    $units = array('B', 'KB', 'MB', 'GB', 'TB');

    $bytes = max($bytes, 0);
    $pow = floor(($bytes ? log($bytes) : 0) / log(1024));
    $pow = min($pow, count($units) - 1);

    $bytes /= pow(1024, $pow);

    return round($bytes, $precision) . ' ' . $units[$pow];
}