# Image Processing Queue

Image Processing Queue is an alternative to on-the-fly (OTF) image processing (e.g. [Aqua Resizer](https://github.com/syamilmj/Aqua-Resizer)) for WordPress themes.

Like OTF image processing, it allows theme developers to define image sizes for specific theme contexts rather than defining a size for all uploaded images. This greatly reduces the number of resized images and hence reduces disk space usage and the wait time when uploading an image.

Image Processing Queue differs from OTF image processing in how it behaves when an image doesn't exist yet. OTF generates the image right away and the end-user has to wait for the image to be generated. With Image Processing Queue there's no waiting. It immediately returns an image that already exists (that is the closest fit to the image size requested) and adds the image size to a queue. Image sizes are quietly generated in the background using [WP Queue](https://github.com/A5hleyRich/wp-queue).

Image Processing Queue also accommodates responsive themes much better than OTF. It allows theme developers to define a list of image sizes that will work best for their theme's responsive breakpoints. Images generated by Image Processing Queue are added to the post meta so that WordPress core's responsive functions will automatically add them to the `srcset` and delete them from the filesystem when the image is deleted from the Media Library.

## Installation

### Install as a Plugin

To install Image Processing Queue as a plugin search for "[Image Processing Queue](https://wordpress.org/plugins/image-processing-queue/)" in your WordPress dashboard and install it from there.

### Install as a Library

If you're a plugin or theme developer you will need to require Image Processing Queue using Composer:

```
$ composer require deliciousbrains/wp-image-processing-queue
```

The following boilerplate will need adding to your project, which will load the required files and ensure WP cron processes the images in the background:

```php
require_once '/vendor/autoload.php';
wp_queue()->cron();
```

The following database tables will also need creating:

```sql
CREATE TABLE {$wpdb->prefix}queue_jobs (
id bigint(20) NOT NULL AUTO_INCREMENT,
job longtext NOT NULL,
attempts tinyint(3) NOT NULL DEFAULT 0,
reserved_at datetime DEFAULT NULL,
available_at datetime NOT NULL,
created_at datetime NOT NULL,
PRIMARY KEY  (id)

CREATE TABLE {$wpdb->prefix}queue_failures (
id bigint(20) NOT NULL AUTO_INCREMENT,
job longtext NOT NULL,
error text DEFAULT NULL,
failed_at datetime NOT NULL,
PRIMARY KEY  (id)
```

You can use the `wp_queue_install_tables()` helper function to create the required database tables. This should be called from within an [activation hook](https://developer.wordpress.org/reference/functions/register_activation_hook/) or custom upgrade routine.

## Usage

When you want to output an image in your theme, simply call the `ipq_get_theme_image()` function passing in the ID of the image post, an array of sizes you've decided on for the image in this particular context, and an array of additional HTML attributes for the `<img>` tag:

```php
echo ipq_get_theme_image( $post_id, array(
        array( 600, 400, false ),
        array( 1280, 720, false ),
        array( 1600, 1067, false ),
    ),
    array(
        'class' => 'header-banner'
    )
);
```

You can return an image URL directly using the `ipq_get_theme_image_url()` function by passing in the image ID and required size. If the image size doesn't exist it will be pushed to the queue and the closest matching image URL will be returned.

```php
echo ipq_get_theme_image_url( $post_id, array( 600, 400, false ) );
```

## License

[GPLv2+](http://www.gnu.org/licenses/gpl-2.0.html)
